#include "commons.h"
#include <Ws2tcpip.h>
#include <iostream>


bool initWinNet()
{
	WSADATA wsData;

	int erStat = WSAStartup(MAKEWORD(2, 2), &wsData);

	if (erStat != 0) {
#ifdef INTENSE_LOGS
		std::cout << "Error WinSock version initializaion #";
		std::cout << WSAGetLastError();
#endif
		return false;
	}
	else {
#ifdef INTENSE_LOGS
		std::cout << "WinSock initialization is OK" << std::endl;
#endif
	}
	return true;
}

bool InitWinNetworkOpenSocket(SOCKET &sock)
{
	if (!initWinNet())
		return false;

	return openSocket(sock);
}

bool openSocket(SOCKET &sock)
{
	sock = socket(AF_INET6, SOCK_DGRAM, IPPROTO_UDP);

	if (INVALID_SOCKET == sock) {
#ifdef INTENSE_LOGS
		std::cout << "Error initialization socket # " << WSAGetLastError() << std::endl;
#endif
		WSACleanup();
		return false;
	}
	else
	{
#ifdef INTENSE_LOGS
		std::cout << "socket initialization is OK" << std::endl;
#endif
	}

	return true;
}

struct sockaddr_in6 *generateConnectionObject(const char * hostname, const char *port)
{
	struct addrinfo *result = NULL;
	struct addrinfo *ptr = NULL;
	struct addrinfo hints;

	// , ,     
	ZeroMemory(&hints, sizeof(hints));
	hints.ai_family = AF_INET6;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = IPPROTO_UDP;
	hints.ai_flags = 0;

	//  ,  
	int rez = getaddrinfo(hostname, port, &hints, &result);
	//   -  -
	if (rez != 0)
	{
		std::cerr << "getaddrinfo failed with error: " << rez << std::endl;
		return nullptr;
	}
	//     ,   ,  : ..  IPv6
	for (ptr = result; ptr != NULL; ptr = ptr->ai_next)
	{
		if (ptr->ai_family == AF_INET6)
		{
			//this is over target
			break;
		}
	}
	// ,    -  
	if (ptr == NULL) {
		std::cerr << "Failed to find proper address" << std::endl;
		freeaddrinfo(result);

		return nullptr;
	}
	//  
	struct sockaddr_in6 *retV = new sockaddr_in6;
	//  
	memcpy(retV, ptr->ai_addr, ptr->ai_addrlen);
	//  
	freeaddrinfo(result);
	//  
	return retV;
}
