// UDP_server.cpp:      .
//

#include "targetver.h"
#include <string>
#include <WinSock2.h>
#include <Ws2tcpip.h>
#include <iostream>
#include <stdlib.h>
#include <memory>
#include <vector>
#include <cstdlib>
#include <ctime>
#include <synchapi.h>

#include "../commons.h"


#pragma comment(lib, "ws2_32.lib")

#define MODE_IPV6

#define INTENSE_LOGS
#define DEFAULT_LISTEN_PORT "64500"
#define MAX_UDPv6_PAYLOAD 65527

#define LISTEN_INTERFACE "::"
//#define LISTEN_INTERFACE "localhost"

void serverPayload(SOCKET &sock, struct sockaddr_in6 &cliaddr, const char * buff, int buffLen);


typedef std::basic_string<TCHAR> String;
String GetErrorMessage(DWORD dwErrorCode);




int main()
{
	SOCKET server_sock;

	if (!InitWinNetworkOpenSocket(server_sock))
	{
		return EXIT_FAILURE;
	}

	struct sockaddr_in6 *server_sockaddr = generateConnectionObject(LISTEN_INTERFACE, DEFAULT_LISTEN_PORT);
	if (server_sockaddr == nullptr)
	{
		std::cerr << "Failed to find proper setting for socket" << std::endl;
		closesocket(server_sock);
		WSACleanup();
		return EXIT_FAILURE;
	}
	int addrLen = sizeof(*server_sockaddr);
	//if we got here - data is properly acquired and port can be bound
	auto rv = bind(server_sock, (SOCKADDR*)server_sockaddr, addrLen);
	if (0 != rv) {
		auto le = GetLastError();
		std::cerr << "Failed to bind socket to found port with error" <<le << std::endl;
		closesocket(server_sock);
		WSACleanup();
		return EXIT_FAILURE;
	}
	else {
#ifdef INTENSE_LOGS
		std::cout << "Binding of port was successfull" << std::endl;
#endif
	}

	// as soon as socket is bound, we are ready to accept incoming datagramms and work on them
	char *buffer = new char[MAX_UDPv6_PAYLOAD];
	while (true)
	{
		struct sockaddr_in6 cliaddr;

		int len = sizeof(cliaddr);
		int n = recvfrom(server_sock, (char *)buffer, MAX_UDPv6_PAYLOAD, 0, (struct sockaddr *) &cliaddr, &len);
		if (n > 0)
			serverPayload(server_sock, cliaddr, buffer, n);
		else {
			auto le = GetLastError();
			auto err = GetErrorMessage(le);
			std::cerr << "recvfrom returned " << n << "  with LE=" << le << "  indicating " << std::endl;
		}
	}

	delete[] buffer;
	delete server_sockaddr;
	closesocket(server_sock);
	WSACleanup();
	return EXIT_SUCCESS;
}


void serverPayload(SOCKET &sock,  struct sockaddr_in6 &cliaddr, const char * buff, int buffLen)
{
	std::string msg(buff, buffLen);
	const std::string msg_ok("OK");
	const std::string msg_bad("BAD");
	std::string ip_address;
	int structLen = sizeof(struct sockaddr_in6);

	char ipstringbuffer[50];

		inet_ntop(AF_INET6, &(cliaddr.sin6_addr), ipstringbuffer, 46);
		ip_address = std::string(ipstringbuffer);

	std::cout << "On server received:" <<  "UDP6" << ":" << ip_address << ":" << ntohs(cliaddr.sin6_port) << ":" << msg << std::endl;
	//comparing of received data
	if (msg == "EEE")
		sendto(sock, msg_ok.data(), msg_ok.size(), 0, (SOCKADDR*)&cliaddr, structLen);
	else
		sendto(sock, msg_bad.data(), msg_bad.size(), 0, (SOCKADDR*)&cliaddr, structLen);
	return;
}

String GetErrorMessage(DWORD dwErrorCode)
{
	LPTSTR psz = NULL;
	const DWORD cchMsg = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM
		| FORMAT_MESSAGE_IGNORE_INSERTS
		| FORMAT_MESSAGE_ALLOCATE_BUFFER,
		NULL, // (not used with FORMAT_MESSAGE_FROM_SYSTEM)
		dwErrorCode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		reinterpret_cast<LPTSTR>(&psz),
		0,
		NULL);
	if (cchMsg > 0)
	{
		// Assign buffer to smart pointer with custom deleter so that memory gets released
		// in case String's c'tor throws an exception.
		auto deleter = [](void* p) { ::HeapFree(::GetProcessHeap(), 0, p); };
		std::unique_ptr<TCHAR, decltype(deleter)> ptrBuffer(psz, deleter);
		return String(ptrBuffer.get(), cchMsg);
	}
	else
	{
		throw std::runtime_error("Failed to retrieve error message string.");
	}
}
