/* UDP_client.cpp:      .
  ,     
 ,   
*/

#include "../commons.h"
#include <Ws2tcpip.h>
//    ++  ,   
#include <string>
#include <iostream>
#include <memory>
#include <vector>
#include <cstdlib>
#include <ctime>
//     Windows
#include <synchapi.h>

#pragma comment(lib, "ws2_32.lib")

// ,    
#define INTENSE_LOGS
//   ,    
#define SERVER_NAME "localhost"
// ,     .   , .. 
//        
#define DEFAULT_PORTNUM "64500"

//  .   :  ; ;     
bool exchangeUDPFunction(const std::string &hostname, const std::string &portnum, const std::string &message, int idx  = -1);
// ,          
struct sockaddr_in6 *generateConnectionObject(const char * hostname, const char *port);

int main()
{

	// ,     Windows
	if (!initWinNet())
	{
		std::cerr << "Failed to initialize network subsystem. Exiting" << std::endl;
		exit(EXIT_FAILURE);
	}
	// .    ,      :
	std::vector<std::string>  messages{
		"hello, Kitty",
		"EEE",
		"what's up?",
		"comment ca va?",
		"Salut!!!",
		"EEE2",
		"EEE"
	};

	// -   
	std::srand(std::time(nullptr)); //    
	//    ,   ,  
	while (true)
	{
		
		auto index = std::rand() / ((RAND_MAX + 1u) / messages.size()); //  
		//          
		exchangeUDPFunction(SERVER_NAME, DEFAULT_PORTNUM, messages[index], index);

		//now lets wait some time 0.1 ... 5 seconds in 0.1 seconds
		auto delay_ms = 100 + 100 * std::rand() / ((RAND_MAX + 1u) / 50);
		Sleep(delay_ms);
	}

	//   ,     
	WSACleanup();
	exit(EXIT_SUCCESS);
}

// .     :      -,    
// .
bool exchangeUDPFunction(const std::string &hostname, const std::string &portnum, const std::string &message, int idx)
{
	//       - 
	//,            
	//  ,   
	//      

	//  :
	SOCKET client_sock;
	if (!openSocket(client_sock)) {
		std::cerr << "Failed to open socket. Need to exit" << std::endl;
		return false;
	}

	struct sockaddr_in6 *server_sockaddr = generateConnectionObject(hostname.c_str(), portnum.c_str());
	if (server_sockaddr == nullptr)
	{
		std::cerr << "Failed to find connection parameters. Can not find service" << std::endl;
		closesocket(client_sock);
		return false;
	}
	int addrLen = sizeof(*server_sockaddr);
	// !  
	auto bytes_sent = sendto(client_sock, message.c_str(), message.length(), 0, (SOCKADDR*)server_sockaddr, addrLen);
#ifdef INTENSE_LOGS
	std::cout << "Just sent messsage with index " << idx << "  \"" << message << "\". Sent size =" << bytes_sent << std::endl;
#endif
	//   .    
	char RecvBuf[1024];
	int recLen = 1024;
	int SenderAddrSize = addrLen;

	// 
	auto rc = recvfrom(client_sock, RecvBuf, recLen, 0, (SOCKADDR*)server_sockaddr, &SenderAddrSize);
	// ,    
	if (rc == -1) {
		auto le = GetLastError();
		if (le == WSAEOPNOTSUPP)
		{
			std::cerr << "Failure on receiving of datagram from remove socket. Exiting" << std::endl;
			delete server_sockaddr;
			closesocket(client_sock);
			return false;
		}
		std::cout << "No datagram received" << std::endl;
		delete server_sockaddr;
		closesocket(client_sock);
		return true;
	}

	char ipstringbuffer[50];
	std::string ip_address;
	
	inet_ntop(AF_INET6, &server_sockaddr->sin6_addr, ipstringbuffer, 46);
	ip_address = std::string(ipstringbuffer);

	std::string msg(RecvBuf, rc);
	std::cout << "Client received from server:" << "UDP6"  << ":" << ip_address << ":" << ntohs(server_sockaddr->sin6_port) << ":" << msg << std::endl;
	// 
	delete server_sockaddr;
	closesocket(client_sock);

	return true;
}
