// UDP_server.cpp:      .
//

#include "targetver.h"
#include <string>
#include <WinSock2.h>
#include <Ws2tcpip.h>
#include <iostream>
#include <stdlib.h>
#include <memory>
#include <vector>
#include <cstdlib>
#include <ctime>
#include <synchapi.h>


#pragma comment(lib, "ws2_32.lib")

// select one of the working modes
//#define MODE_IPV4
//#define MODE_IPV6
//#define MODE_IPvA

#if (! defined(MODE_IPV4))  && (! defined ( MODE_IPV6)) && (! defined (MODE_IPvA))
	#error("One of the modes should be selected")
#endif

#if (defined(MODE_IPV4) && defined (MODE_IPV6) ) || (defined(MODE_IPV4) && defined (MODE_IPvA) ) || (defined(MODE_IPV6) && defined (MODE_IPvA) )
	#error("Only one mode of MODE_IPV4 MODE_IPV6 MODE_IPvA should be selected")
#endif

#define INTENSE_LOGS

#define DEFAULT_LISTEN_PORT "64000"

#ifdef MODE_IPV4
	#define DEFAULT_LISTEN_INTERFACE INADDR_ANY 
#else
	#define DEFAULT_LISTEN_INTERFACE IN6ADDR_ANY_INIT 
#endif

#define MAX_CLIENTS_SERVER_QUEUE  10
#define MAX_UDPv6_PAYLOAD 65527


int runServerSide(int, const char *[]);
int runClientSide(int, const char *[]);
bool InitWinNetworkOpenSocket(SOCKET &sock);
bool initWinNet();
bool openSocket(SOCKET &sock);
void serverPayload(SOCKET &, struct sockaddr *cliaddr, const char *, int);

void show_info()
{
	std::cout << "This version is built as ";
#ifdef MODE_IPV6
	std::cout << "  UDP6";
#elif defined MODE_IPV4
	std::cout << "  UDP4";
#else
	std::cout << "UDPx";
#endif
	std::cout << "  version" << std::endl;
	std::cout << "Application can run in 2 main modes:" << std::endl;
	std::cout << "\t-s   as server" << std::endl;
	std::cout << "\t-c   as a client" << std::endl;
	std::cout << "SERVER MODE arguments:" << std::endl;
	std::cout << "  call conversion 1" << std::endl;
	std::cout << "\t1)  address  port" << std::endl;
	std::cout << "\t2)  port" << std::endl;
	std::cout << "\t\twhere port - is portnum to listen for incoming datagramms. used "<< DEFAULT_LISTEN_PORT<<"  if omitted" << std::endl;
	std::cout << "\t\t     address - IP-address, or hostname which should be used for opening port. used  127.0.0.1 if omitted " << std::endl;
	std::cout << std::endl;
	std::cout << "CLIENT MODE arguments:" << std::endl;
	std::cout << "  [ address [port]]" << std::endl;
	std::cout << "\t\twhere address - hostname or IP or other name of server to connect to. \"localhost\" is used if omitted" << std::endl;
	std::cout << "\t\t       port - port number to establish connection. " << DEFAULT_LISTEN_PORT << "  is used if omitted " << std::endl;

}

int main(int argc, const char * argv[])
{
	bool ServerMode = true;
	bool consumeArgs = false;
	bool ClientMode = false;
	//if arguments are present and first argument like "-s" "-c" "s" "c" we can treat it as server/client mode
	// if first argument is missing or does not match expectations - server mode is default
	if (argc > 1) {
		if (0 == strcmp(argv[1], "s") || 0 == strcmp(argv[1], "-s"))
		{
			ServerMode = true;
			consumeArgs = true;
		}
		if (0 == strcmp(argv[1], "c") || 0 == strcmp(argv[1], "-c"))
		{
			ServerMode = false;
			ClientMode = true;
			consumeArgs = true;
		}
		if (0 == strcmp(argv[1], "-h") || 0 == strcmp(argv[1], "--help") || 0 == strcmp(argv[1], "/?"))
		{
			show_info();
			exit(EXIT_SUCCESS);
		}
	}
	if (ServerMode)
		return runServerSide(argc - (consumeArgs?1:0), argv + (consumeArgs ? 1 : 0));

	if (ClientMode)
		return runClientSide(argc-1, argv + 1);

	std::cerr << "Failed to determine mode of launch" << std::endl;
    return EXIT_FAILURE;
}

typedef std::basic_string<TCHAR> String;

String GetErrorMessage(DWORD dwErrorCode)
{
	LPTSTR psz = NULL;
	const DWORD cchMsg = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM
		| FORMAT_MESSAGE_IGNORE_INSERTS
		| FORMAT_MESSAGE_ALLOCATE_BUFFER,
		NULL, // (not used with FORMAT_MESSAGE_FROM_SYSTEM)
		dwErrorCode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		reinterpret_cast<LPTSTR>(&psz),
		0,
		NULL);
	if (cchMsg > 0)
	{
		// Assign buffer to smart pointer with custom deleter so that memory gets released
		// in case String's c'tor throws an exception.
		auto deleter = [](void* p) { ::HeapFree(::GetProcessHeap(), 0, p); };
		std::unique_ptr<TCHAR, decltype(deleter)> ptrBuffer(psz, deleter);
		return String(ptrBuffer.get(), cchMsg);
	}
	else
	{
		throw std::runtime_error("Failed to retrieve error message string.");
	}
}




int runServerSide(int argc, const char *argv[])
{
	SOCKET server_sock;
	struct addrinfo *result = NULL;
	struct addrinfo *ptr = NULL;
	struct addrinfo hints;

	if (!InitWinNetworkOpenSocket(server_sock))
	{
		return EXIT_FAILURE;
	}

	ZeroMemory(&hints, sizeof(hints));
#if defined( MODE_IPV6) || defined (MODE_IPvA)

	hints.ai_family = AF_INET6;
#else
	hints.ai_family = AF_INET;
#endif
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = IPPROTO_UDP;
	hints.ai_flags = 0;
	//time to bind socket to desired port and address, if provided.
	// can be only port, or address + port on command line
	//getting address info
	if (argc > 2)
	{
		//first should be address next port
		int rez = getaddrinfo(argv[1], argv[2], &hints, &result);
		if (rez != 0)
		{
			std::cerr << "getaddrinfo failed with error: " << rez << std::endl;
			WSACleanup();
			return EXIT_FAILURE;
		}
	}
	else if (argc > 1)
	{
		//only portnum
		int rez = getaddrinfo(nullptr, argv[2], &hints, &result);
		if (rez != 0)
		{
			std::cerr << "getaddrinfo failed with error: " << rez << std::endl;
			WSACleanup();
			return EXIT_FAILURE;
		}
	}
	else {
		//portnum and host are defaults
		int rez = getaddrinfo(nullptr, DEFAULT_LISTEN_PORT, &hints, &result);
		if (rez != 0)
		{
			std::cerr << "getaddrinfo failed with error: " << rez << std::endl;
			WSACleanup();
			return EXIT_FAILURE;
		}
	}
	for (ptr = result; ptr != NULL; ptr = ptr->ai_next)
	{
		if ((ptr->ai_family ==
#if defined( MODE_IPV4)
			AF_INET)
#elif defined (MODE_IPV6)
			AF_INET6)
#else
			AF_INET) || (ptr->ai_family == AF_INET6)
#endif
			)
		{
			//this is over target
			break;
		}
	}
	if (ptr == NULL) {
		std::cerr << "Failed to find proper address" << std::endl;
		freeaddrinfo(result);
		closesocket(server_sock);
		WSACleanup();
		return EXIT_FAILURE;
	}
	//if we got here - data is properly acquired and port can be bound
	auto rv = bind(server_sock, ptr->ai_addr, ptr->ai_addrlen);
	if (0 != rv) {
		auto le = GetLastError();
		std::cerr << "Failed to bind socket to found port with error" <<le << std::endl;
		freeaddrinfo(result);
		closesocket(server_sock);
		WSACleanup();
		return EXIT_FAILURE;
	}
	else {
#ifdef INTENSE_LOGS
		std::cout << "Binding of port was successfull" << std::endl;
#endif
	}
	freeaddrinfo(result);


	// as soon as socket is bound, we are ready to accept incoming datagramms and work on them
	char *buffer = new char[MAX_UDPv6_PAYLOAD];
	while (true)
	{
#ifdef MODE_IPV4
		struct sockaddr_in cliaddr;
#endif
#if defined( MODE_IPV6) || defined (MODE_IPvA)
		struct sockaddr_in6 cliaddr;

#endif
		int len = sizeof(cliaddr);
		int n = recvfrom(server_sock, (char *)buffer, MAX_UDPv6_PAYLOAD, 0, (struct sockaddr *) &cliaddr, &len);
		if (n > 0)
			serverPayload(server_sock, (struct sockaddr *)&cliaddr, buffer, n);
		else {
			auto le = GetLastError();
			auto err = GetErrorMessage(le);
			std::cerr << "recvfrom returned " << n << "  with LE=" << le << "  indicating " << std::endl;
		}
	}

	delete[] buffer;
	closesocket(server_sock);
	WSACleanup();
	return EXIT_SUCCESS;
}


struct sockaddr *generateConnectionObject(const char * hostname, const char *port)
{



	struct addrinfo *result = NULL;
	struct addrinfo *ptr = NULL;
	struct addrinfo hints;


	ZeroMemory(&hints, sizeof(hints));
#if defined( MODE_IPV6) || defined (MODE_IPvA)

	hints.ai_family = AF_INET6;
#else
	hints.ai_family = AF_INET;
#endif
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = IPPROTO_UDP;
	hints.ai_flags = 0;
	int rez = getaddrinfo(hostname, port, &hints, &result);
	if (rez != 0)
	{
			std::cerr << "getaddrinfo failed with error: " << rez << std::endl;
			return nullptr;
	}

	for (ptr = result; ptr != NULL; ptr = ptr->ai_next)
	{
		if ((ptr->ai_family ==
#if defined( MODE_IPV4)
			AF_INET)
#elif defined (MODE_IPV6)
			AF_INET6 )
#else
			AF_INET) || (ptr->ai_family == AF_INET6)
#endif
			)
		{
			//this is over target
			break;
		}
	}
	if (ptr == NULL) {
		std::cerr << "Failed to find proper address" << std::endl;
		freeaddrinfo(result);

		return nullptr;
	}

#ifdef MODE_IPV6
	struct sockaddr_in6 *retV = new sockaddr_in6;
#elif defined (MODE_IPV4)
	struct sockaddr_in *retV = new sockaddr_in;
#else
	struct sockaddr *retV = new sockaddr;
#endif

	memcpy(retV, ptr->ai_addr, ptr->ai_addrlen);
	freeaddrinfo(result);

	return reinterpret_cast<struct sockaddr *>(retV);
}

int runClientSide(int argc, const char *argv[])
{

	std::vector<std::string>  messages{
		"hello, Kitty",
		"EEE",
		"what's up?",
		"comment ca va?",
		"Salut!!!",
		"EEE2",
		"EEE"
	};
	SOCKET client_sock;
	struct sockaddr *server_sockaddr = nullptr;
	const char *portArgument = nullptr;
	const char *addressArgument = nullptr;
	//here we have several options:
	// 1) create/allocate socket each time
	// 2) create one socket per application and send messages always from same socket
//#define USE_ONE_SOCKET
#ifdef USE_ONE_SOCKET
	if (!InitWinNetworkOpenSocket(client_sock))
	{
		return EXIT_FAILURE;
	}
#else
	if (!initWinNet())
	{
		return EXIT_FAILURE;
	}
#endif

	std::srand(std::time(nullptr));
	//fetching target address:port from command line into variable:
	if (argc >= 3)
		portArgument = argv[2];
	if (argc >= 2)
		addressArgument = argv[1];
	server_sockaddr = generateConnectionObject(addressArgument == nullptr ? "localhost" : addressArgument,
		portArgument == nullptr ? DEFAULT_LISTEN_PORT: portArgument );
	if (server_sockaddr == nullptr)
	{
		WSACleanup();
		return EXIT_FAILURE;
	}
	int addrLen = server_sockaddr->sa_family == AF_INET ? sizeof(struct sockaddr_in) : sizeof(struct sockaddr_in6);

	while (true)
	{
#ifndef USE_ONE_SOCKET
		if (!openSocket(client_sock))
		{
			std::cerr << "Failed to open socket" << std::endl;
			continue;
		}
#endif
		// common part for both cases of one socket for each connection and each time new socket
		auto index = std::rand() / ( (RAND_MAX + 1u) / messages.size() );
		auto bytes_sent = sendto(client_sock, messages[index].c_str(), messages[index].length(), 0, server_sockaddr, addrLen);
#ifdef INTENSE_LOGS
		std::cout << "Just sent messsage with index "<<index<<"  \"" << messages[index] << "\". Sent size =" << bytes_sent << std::endl;
#endif
		char RecvBuf[1024];
		int recLen = 1024;
		int SenderAddrSize = addrLen;

		auto rc = recvfrom(client_sock, RecvBuf, recLen, 0, server_sockaddr, &SenderAddrSize);
		if (rc == -1) {
			auto le = GetLastError();
			if (le == WSAEOPNOTSUPP)
			{
				std::cerr << "Failure on receiving of datagram from remove socket. Exiting" << std::endl;
				break;
			}
		}
		else {

			struct sockaddr_in6 *sockaddr_ipv6;
			struct sockaddr_in *sockaddr_ipv4;

			char ipstringbuffer[50];
			std::string ip_address;
			sockaddr_ipv4 = (struct sockaddr_in *) server_sockaddr;

			if (server_sockaddr->sa_family == AF_INET6)
			{
				sockaddr_ipv6 = (struct sockaddr_in6 *) server_sockaddr;
				inet_ntop(AF_INET6, &sockaddr_ipv6->sin6_addr, ipstringbuffer, 46);
				ip_address = std::string(ipstringbuffer);
			}
			else if (server_sockaddr->sa_family == AF_INET)
			{
				inet_ntop(AF_INET, &sockaddr_ipv4->sin_addr, ipstringbuffer, 47);
				ip_address = std::string(ipstringbuffer);
			}
			else {
				ip_address = "UKN";
			}
			std::string msg(RecvBuf, rc);
			std::cout << "On server received:" << (server_sockaddr->sa_family == AF_INET6 ? "UDP6" : "UDP4") << ":" << ip_address << ":" << ntohs(sockaddr_ipv4->sin_port) << ":" << msg << std::endl;
		}

#ifndef USE_ONE_SOCKET
		closesocket(client_sock);
#endif
		//now lets wait some time 0.1 ... 5 seconds in 0.1 seconds
		auto delay_ms = 100 + 100 * std::rand() / ((RAND_MAX + 1u) / 50 );
		Sleep(delay_ms);
	}
	

#ifdef USE_ONE_SOCKET
	closesocket(client_sock);
#endif
	WSACleanup();
	if (server_sockaddr != nullptr)
		delete server_sockaddr;
	return EXIT_SUCCESS;
}

bool initWinNet()
{
	WSADATA wsData;

	int erStat = WSAStartup(MAKEWORD(2, 2), &wsData);

	if (erStat != 0) {
#ifdef INTENSE_LOGS
		std::cout << "Error WinSock version initializaion #";
		std::cout << WSAGetLastError();
#endif
		return false;
	}
	else {
#ifdef INTENSE_LOGS
		std::cout << "WinSock initialization is OK" << std::endl;
#endif
	}
	return true;
}

bool openSocket(SOCKET &sock)
{
#ifdef MODE_IPV4
	sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
#else 
	sock = socket(AF_INET6, SOCK_DGRAM, IPPROTO_UDP);
#endif
	if (INVALID_SOCKET == sock) {
#ifdef INTENSE_LOGS
		std::cout << "Error initialization socket # " << WSAGetLastError() << std::endl;
#endif
		closesocket(sock);
		WSACleanup();
		return false;
	}
	else
	{
#ifdef INTENSE_LOGS
		std::cout << "socket initialization is OK" << std::endl;
#endif
	}

	return true;
}


bool InitWinNetworkOpenSocket(SOCKET &sock)
{
	if (!initWinNet())
		return false;

	return openSocket(sock);
}
	

void serverPayload(SOCKET &sock, struct sockaddr *cliaddr, const char * buff, int buffLen)
{
	std::string msg(buff, buffLen);
	const std::string msg_ok("OK");
	const std::string msg_bad("BAD");
	std::string ip_address;
	struct sockaddr_in6 *sockaddr_ipv6;
	struct sockaddr_in *sockaddr_ipv4 = (struct sockaddr_in *) &cliaddr;
	int structLen = sizeof(struct sockaddr_in);

	char ipstringbuffer[50];

	if (cliaddr->sa_family == AF_INET6)
	{
		sockaddr_ipv6 = (struct sockaddr_in6 *) &cliaddr;
		inet_ntop(AF_INET6, &sockaddr_ipv6->sin6_addr, ipstringbuffer, 46);
		structLen = sizeof(struct sockaddr_in6);
		ip_address = std::string(ipstringbuffer);
	}
	else if (cliaddr->sa_family == AF_INET)
	{
		
		inet_ntop(AF_INET, &sockaddr_ipv4->sin_addr, ipstringbuffer, 47);
		ip_address = std::string(ipstringbuffer);
	}
	else {
		ip_address = "UKN";
	}

	std::cout << "On server received:" << (cliaddr->sa_family == AF_INET6 ? "UDP6": "UDP4") << ":" << ip_address << ":" << ntohs(sockaddr_ipv4->sin_port) << ":" << msg << std::endl;
	//comparing of received data
	if (msg == "EEE")
		sendto(sock, msg_ok.data(), msg_ok.size(), 0, cliaddr, structLen);
	else
		sendto(sock, msg_bad.data(), msg_bad.size(), 0, cliaddr, structLen);
	return;
}